import asyncio

from urpc_enum.stackerliftmoverparameter import StackerLiftMoverParameter
from fleming.common.firmware_util import *
from predefined_tasks.common.helper import send_to_gc

PLATE_SENSOR_CURRENT = 0.1
PLATE_SENSOR_LIMIT = 0.2

def get_lift_mover(side):
    if side == 'l' or side == 'left':
        # Instrument MC6.1 as Lift Mover
        can_id = mover_endpoints['fms']['id']
        endpoint = create_endpoint(can_id, 'StackerLiftMoverFunctions')
        return endpoint
    if side == 'r' or side == 'right':
        # Instrument MC6.2 as Lift Mover
        can_id = mover_endpoints['usfm']['id']
        endpoint = create_endpoint(can_id, 'StackerLiftMoverFunctions')
        return endpoint

    raise ValueError(f"Invalid side.")


async def stk_test_plate_sensor():
#Test the Stacker Plate Sensor on MC6, sides left and right, hot plug possible.
#Script v1.0, 01.02.2023, PLATE_SENSOR_LIMIT = 0.2

    result_l = 0
    result_r = 0
    await get_node_endpoint('mc6').Reset()
    await asyncio.sleep(0.5)
    await send_to_gc(f"Starting Firmware")
    await start_firmware('mc6')
    
    lift_mover = get_lift_mover('left')
    await lift_mover.SetParameter(StackerLiftMoverParameter.PlateSensorCurrent, PLATE_SENSOR_CURRENT)
    (signal, base) = await lift_mover.TestPlateSensor()
    result_l = (signal - base)
    print(f"SPS left:  {signal:.4f} - {base:.4f} = {result_l:.4f}")
    if (result_l < PLATE_SENSOR_LIMIT):
        return f"SPS left FAILED."
    
    lift_mover = get_lift_mover('right')
    await lift_mover.SetParameter(StackerLiftMoverParameter.PlateSensorCurrent, PLATE_SENSOR_CURRENT)
    (signal, base) = await lift_mover.TestPlateSensor()
    result_r = (signal - base)
    print(f"SPS right: {signal:.4f} - {base:.4f} = {result_r:.4f}")
    if (result_r < PLATE_SENSOR_LIMIT):
        return f"SPS left PASSED, right FAILED."
    return f"SPS left + right test PASSED (Result l/r: {result_l:.3f}/{result_r:.3f})."
